<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Tech Shop UK - Report</title>
    <link rel="stylesheet" type="text/css" href="style.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="validateForm.js" type="text/javascript" language="JavaScript"></script>
    <script src='https://www.google.com/recaptcha/api.js'></script>
</head>

<body>
<div id="wrapper" class="container">
    <div id="header">
        <nav class="navbar navbar-expand-lg navbar-light bg-light">
            <a class="navbar-brand" href="index.php"><img src="img/TechShopLogo.png" alt="TechShop UK" width="150px"></a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul id="navi" class="navbar-nav mr-auto">
                    <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
                    <li class="nav-item"><a class="nav-link" href="products.php">Products</a> </li>
                    <li class="nav-item"><a class="nav-link" href="featured.php">Featured Products</a> </li>
                    <li class="nav-item"><a class="nav-link" href="register.php">Register</a> </li>
                    <li class="nav-item active"><a class="nav-link" href="report.php">Report</a> </li>
                </ul>
            </div>
            <p><?php
                 if(isset($_SESSION["username"])){
                     echo 'Welcome, '.$_SESSION["username"].". "."<a href='user/user.php'>View Account</a>".". "."<a href='viewBasket.php'>View Basket</a>".". "."<a href='logout.php'>Logout</a>";
                 }else{
                     echo "Click here to <a href='login.php'>login</a>";
                 }
                 ?>
                 </p>
        </nav>
    </div>

    <div class="container-fluid">
        <div id="block" class="row">
            <div id="content" class="col-md-8">
                <h1>Report</h1>
                <p>SOFT20171: Internet Application Development Assignment 2
                <p>Throughout the design of this project, a number of heuristics were considered and adhered to.</p>
                <p>For example, a principle which Nielsen and Budd discuss is consistency and standards. 
                Throughout the site a common colour scheme and layout are employed. 
                To achieve this, Bootstrap is used and a consistent CSS stylesheet is also used.</p>
                <p>Nielsen additionally discusses recognition rather than recall. 
                Throughout the site the buttons and text are consistent and allow the user to easily recognise what the function of the button or text do. 
                Linking into the previous principle, these buttons are consistent across the site. Another key reason for the text buttons is for accessibility. 
                To allow screen-readers to access the site, text buttons were used rather than images as screen-readers are able to read the text from the 
                button but cannot read images.</p>
                <p>Finally, error prevention has been prevalent throughout the site where the users need to enter information. 
                This is another of Nielsen’s principles which ensures that the users enter data in the expected format so that the information 
                which the system subsequently presents is useful to the users. For this a number of validation techniques have been employed in HTML5. 
                Additionally, the use of prepared expressions ensures that the threat of SQL injection attacks are minimised.</p>
                <p>This initially presented an issue as prior to this project, only two expressions were passed to the prepared expression. 
                When attempting to pass more than two, an error occurred. Upon investigation of this error, it was identified that when the expression is called, 
                the first element for example “ss” refers to the number of statements expected – in this case two. When changed to “sss” – three expected statements, 
                the error was eliminated.</p>
                <p>Budd discusses the need for clarity. To achieve this, useful messages are presented to the user. For example, where there are no records to 
                display from the MySQL database, the site will show a message notifying the user that “No items to display”. This shows the user that the 
                site is working as expected – there is just no data for that particular view.</p>
                <p>Overall, I think that the design implemented meets most of Nielsen’s heuristics. However, there are some where it falls short. 
                For example, given more time I would have implemented a basket overview for the user to allow them to see how many items are in their basket from any page. </p>
                <h2>Appendices</h2>
                <p><h3>External sources used for coding support</h3> <br>
                    •	https://getbootstrap.com/docs/4.0/components/navbar/ - Bootstrap documentation for the navigation bar <br>
                    •	https://www.w3schools.com/xml/xml_applications.asp - XML pull code, which I have extensively modified to fit the purpose of this project <br>
                    •	https://www.w3schools.com/css/css3_borders.asp - Rounded corners CSS code <br>
                <h3>Image sources</h3> <br>
                    •	https://www.paypal.com/pe/webapps/mpp/merchant-integration/paypal-button?locale.x=en_PE – PayPal button image – modified <br>
                    •	https://www.ac-foto.com/product/ef-100-40045-56-l-is-usm-ii - Canon 100-400 <br>
                    •	https://www.bhphotovideo.com/c/product/1225875-REG/canon_1263c004_eos_80d_dslr_camera.html - Canon 80D <br>
                    •	https://www.bhphotovideo.com/c/product/1250646-REG/canon_speedlite_600ex_ii_rt.html - Canon Speedlite <br>
                    •	TechShop UK Logo – Created using GIMP <br>
                    •	https://interface-nrm.co.uk/5-star-trustpilot-review-from-vantage-products-limited-ukas-iso-9001-2015-certification/ - TrustPilot 5 star logo <br>
                    •	https://panamoz.com/digital-cameras/canon/canon-eos-80d-dslr-camera-body-only.html - Canon EOS 80D <br>
                    •	https://www.bestbuy.ca/en-ca/product/canon-canon-eos-5d-mark-iv-dslr-camera-body-only-1483c003/10482952.aspx - Canon EOS 5D Mk4 <br>
                    •	https://www.vistek.ca/store/427181/canon-eos-r-full-frame-mirrorless-camera-body-includes-free-efeos - Canon EOS R <br>
                    •	https://www.canon.com.hk/en/product/catalog/productItemDetails.do?prrfnbr=200939 – Canon EOS 750D <br>
                </p>

            </div>
        </div>


    </div>

</div>


<div class="container-fluid">
    <div id="row">
        <div id="footer" class="col-footer">
            <p>&copy; 2018 Will Wright (N0735709). All Rights Reserved.</p>
        </div>
    </div>
</div>

</div>
</body>
</html>