<?php
include "connect.php";
session_start();
if(isset($_SESSION["username"])){
    $username = $_SESSION["username"];
}else{
    Header("Location: login.php");
}

$sql = "SELECT * FROM products JOIN basket ON products.pID = basket.prodID WHERE basket.username = '$username'";
$results = mysqli_query($con,$sql);
$total = 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Tech Shop UK - Basket</title>
    <link rel="stylesheet" type="text/css" href="style.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script>
    <meta name="viewport" content="width=device-width, initial-scale=1">
</head>

<body>
<div id="wrapper" class="container">
    <div id="header">
        <nav class="navbar navbar-expand-lg navbar-light bg-light">
            <a class="navbar-brand" href="index.php"><img src="img/TechShopLogo.png" alt="TechShop UK" width="150px"></a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul id="navi" class="navbar-nav mr-auto">
                    <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
                    <li class="nav-item"><a class="nav-link" href="products.php">Products</a> </li>
                    <li class="nav-item"><a class="nav-link" href="featured.php">Featured Products</a> </li>
                    <li class="nav-item"><a class="nav-link" href="register.php">Register</a> </li>
                    <li class="nav-item"><a class="nav-link" href="report.php">Report</a> </li>
                </ul>
            </div>
            <p><?php
                 if(isset($_SESSION["username"])){
                     echo 'Welcome, '.$_SESSION["username"].". "."<a href='user/user.php'>View Account</a>".". "."<a href='viewBasket.php'>View Basket</a>".". "."<a href='logout.php'>Logout</a>";
                 }else{
                     echo "Click here to <a href='login.php'>login</a>";
                 }
                 ?>
                 </p>
        </nav>
    </div>

    <div class="container-fluid">
        <div id="block" class="row">
            <div id="content" class="col-md-8">
                <h1>Basket</h1>
                <?php
                if(mysqli_num_rows($results) > 0){
                    echo "<table style='width=100%' class='basketTable'>
                    <tr>
                    <th>Product</th>
                    <th>Quantity</th>
                    <th>Cost per item</th>
                    </tr>";
                    while($row = mysqli_fetch_assoc($results)){
                        echo "<tr>";
                        echo "<td>".$row["ProductName"]."</td>".
                        "<td>".$row["quantity"]."</td>".
                        "<td>".$row["Cost"]."</td></tr>";
                        
                        $price = (int)$row["Cost"];
                        $quantity = (int)$row["quantity"];
                        $prodTotal = $price*$quantity;
                        $total += $prodTotal;
                    }
                    echo "</table>";
                }else{
                    echo "Basket is empty. Click <a href='products.php'>here</a> to see our products";
                }
                ?>
            </div>
            <div id="sidebar" class="col-md-4">
                <?php echo "<h3>Your total is: £" . $total."</h3>";?><br>
                Click <a href="confirm.php">here</a> to confirm.
            </div>
                </div>
            </div>
        </div>

    </div>


    <div class="container-fluid">
        <div id="row">
            <div id="footer" class="col-footer">
                <p>&copy; 2018 Will Wright (N0735709). All Rights Reserved.</p>
            </div>
        </div>
    </div>

</div>
</body>
</html>